<?php

namespace App\Http\Controllers\API\v1;
use Spatie\Permission\Models\Permission;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;
use Illuminate\Http\Request;
use App\Http\Resources\AuthResource;
use Illuminate\Support\Str;
use App\Models\User;
use App\Models\Config;
use Image;


class AuthController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }


    public function check_auth(Request $request){
        if (auth()->check()) {
            $user = auth()->user();
            return response()
                        ->json([
                            'user' => new AuthResource($user)
                        ], 200);
        }
        return response()->json('Unauthorized', 401);
    }

    public function create_role_test(Request $request){
        
        // $permissions = [
        //     ["name" => 'create role'],
        //     ["name" => 'read role'],  
        //     ["name" => 'update role'],          
        //     ["name" => 'delete role']
        // ];
        
        $role = Role::create(['name' => 'Sales Executive', 'description' => "New Sales Executives"]);
        // foreach($permissions as $permission){
        //     $new_permission = Permission::create($permission);
        //     $role->givePermissionTo($new_permission);
        // }
        // // $role->syncPermissions($updated_permissions);

        $user = User::find(1);
        // $user->all_permissions();

        // $user->assignRole($role);

        // $users = user::with(['roles'])->get();


        return response()->json([
            'data3' =>  Role::get()
        ], 200);
    }



    public function delete_user(Request $request, $id){
        $user = User::find($id);
        $user->delete();
        return response()->json([
            'id' => intval($id)
        ]);
    }


    public function get_config(Request $request){
        $config = Config::pluck('value', 'name')->all();
        return response()->json([
            'config' => $config
        ]);
    }

}
