<?php

namespace App\Http\Controllers\API\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Media;
use \Milon\Barcode\DNS2D;
use PDF;
use Log;

class MediaController extends Controller
{
    
    public function get(Request $request, $id){
        $item = Media::find($id);
        if($item){       
            $path = storage_path($item->path);     
            return response()->download($path);
        }else{
            return response()->json([ 'message' => "File not found" ], 415);
        }
    }

    public function delete(Request $request, $id){
        $item = Media::find($id)->delete();        
        return response()->json([ 'id' => $id ]);        
    }


    public function print(Request $request){   

        $d = new DNS2D();        
        // $qrcode = $d->getBarcodePNG('AHE-220001', 'C39');
        $qrcode = $d->getBarcodePNG('AHE-220001', 'QRCODE');

        $config = [
            'format' => [54, 86],
            'margin_top' => 0,
            'margin_left' => 0,
            'margin_right' => 0,
            'margin_bottom' => 0,
            'title' => 'Axiom Student Card',
            'author' => 'Axiom School',
        ];
        $data = [
            'name' => 'Muhammad Abdullah',
            'avatar' => base_path("public/assets/avatar.png"),
            'qrcode'  => $qrcode,
            'title' => 'Play Group (A)'
          ];
        
          $pdf = PDF::loadView('student_card', $data, [], $config);
          return $pdf->stream('document.pdf');
    }


}
