<?php

namespace App\Http\Controllers\API\v1;

use App\Http\Controllers\Controller;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use Illuminate\Http\Request;
use App\Http\Resources\RoleResource;
use App\Http\Requests\RoleRequest;



class RoleController extends Controller
{
    
    public function get(){
        $roles = Role::all();
        return response()->json([
            'roles' => RoleResource::collection($roles)
        ]);
    }

    public function create(RoleRequest $request){

        $role = Role::create([
            'name'  => $request->title,
            'title' => $request->description
        ]);

        foreach($request->permissions as $permit){
            $new_permission = Permission::updateOrCreate(['name' => $permit], ['name' => $permit]);
            $role->givePermissionTo($new_permission);
        }
                
        return response()->json([
            'role' => new RoleResource($role)
        ]);
    }

    public function update(RoleRequest $request, $id){

        $role = Role::find($id);
        $role->name = $request->title;
        $role->title = $request->description;
        $role->save();        
        // $all_permissions = [];
        foreach($request->permissions as $permit){
            $new_permission = Permission::updateOrCreate(['name' => $permit], ['name' => $permit]);
            // $all_permissions[] = $new_permission;            
        }

        $role->syncPermissions($request->permissions ?? []);
                
        return response()->json([
            'role' => new RoleResource($role)
        ]);
    }

    public function delete(Request $request, $id){
        $role = Role::find($id);
        $role->delete();
        return response()->json([
            'id' => intval($id)
        ]);
    }


    public function resources(Request $request){
        $resources = [
            [
                "title"  => "Management",
                "data"   => [                    
                    [
                        "label" => 'Roles',
                        "name" =>  'role',        
                        "description" =>  '',
                        "permissions" => [
                            ["name" => 'create role', 'description' => 'can create roles'],
                            ["name" => 'read role', 'description' => 'can view roles'],
                            ["name" => 'update role', 'description' => 'can update roles'],
                            ["name" => 'delete role', 'description' => 'can delete roles']
                        ]
                    ],
                    [
                        "label" => "Staff",
                        "name"  => "staff",
                        "permissions"   => [
                            ["name" => 'create staff', 'description' => 'can create staff members'],
                            ["name" => 'update staff', 'description' => 'can update staff members'],
                            ["name" => 'read staff', 'description' => 'can view all staff members'],
                            ["name" => 'delete staff', 'description' => 'can delete staff members']
                        ]
                    ],
                    [
                        "label" => "Students",
                        "name"  => "student",
                        "permissions"   => [
                            ["name" => 'create student', 'description' => 'can create students'],
                            ["name" => 'update student', 'description' => 'can update students'],
                            ["name" => 'read student', 'description' => 'can view all students'],
                            ["name" => 'delete student', 'description' => 'can delete students']
                        ]
                    ],
                    [
                        "label" => "Parents",
                        "name"  => "parent",
                        "permissions"   => [
                            ["name" => 'create parent', 'description' => 'can create parent users'],
                            ["name" => 'update parent', 'description' => 'can update parent users'],
                            ["name" => 'read parent', 'description' => 'can view all parent userss'],
                            ["name" => 'delete parent', 'description' => 'can delete parent users']
                        ]
                    ],
                    [
                        "label" => 'Campuses',
                        "name" =>  'campus',        
                        "description" =>  '',
                        "permissions" => [
                            ["name" => 'operate campus', 'description' => 'can manage/administer campus'],
                            ["name" => 'create campus', 'description' => 'can create campus'],
                            ["name" => 'read campus', 'description' => 'can view campus'],
                            ["name" => 'update campus', 'description' => 'can update campus'],                    
                            ["name" => 'delete campus', 'description' => 'can delete campus']
                        ]
                    ],
                ]
            ],
            [
                "title"  => "Accounts & Finance",
                "data"   => [                    
                    [
                        "label" => 'Fees & Funds',
                        "name" =>  'fee',        
                        "description" =>  '',
                        "permissions" => [
                            ["name" => 'create fee', 'description' => 'can create fee invoices'],
                            ["name" => 'read fee', 'description' => 'can view fee invoices'],
                            ["name" => 'update fee', 'description' => 'can update fee invoices'],
                            ["name" => 'delete fee', 'description' => 'can delete fee invoices']
                        ]
                    ],
                    [
                        "label" => "Payroll",
                        "name"  => "payroll",
                        "permissions"   => [
                            ["name" => 'create payroll', 'description' => 'can create new payroll'],
                            ["name" => 'update payroll', 'description' => 'can update payrolls'],
                            ["name" => 'read payroll', 'description' => 'can view all payrolls'],
                            ["name" => 'delete payroll', 'description' => 'can delete payrolls']
                        ]
                    ],
                    [
                        "label" => "Expenses",
                        "name"  => "expense",
                        "permissions"   => [
                            ["name" => 'create expense', 'description' => 'can create expenses'],
                            ["name" => 'update expense', 'description' => 'can update expenses'],
                            ["name" => 'read expense', 'description' => 'can view all expenses'],
                            ["name" => 'delete expense', 'description' => 'can delete expenses']
                        ]
                    ]                    
                ]
            ]
                                   
            
        ];
        return response()->json([
            'resources' => $resources,
        ], 200);    
    }


}
