<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class FeePlanRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [                    
            'fees.*.type'   => 'bail|required',
            'fees.*.amount'   => 'bail|required',            
        ];
    }
    
    /**
     * messages
     *
     * @return void
     */
    public function messages(){
        return [                        
            'fees.*.type.required' => 'Fee type is required',            
            'fees.*.amount.required' => 'Fee amount is required',            
        ];
    }
}
