<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class FeeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [   
            'status'            => 'bail|required',
            'month'             => 'bail|required',
            'due_date'          => 'bail|required',            
            'payment_date'      => 'bail|required_if:status,PAID',
            'method'            => 'bail|required_if:status,PAID',
            'charges.*.type'    => 'bail|required',
            'charges.*.amount'  => 'bail|required',
            'total_amount'      => 'bail|required_if:status,PARTIALLY PAID'
        ];
    }

    /**
     * messages
     *
     * @return void
     */
    public function messages(){
        return [                        
            'fees.*.type.required'          => 'Fee type is required',            
            'fees.*.amount.required'        => 'Fee amount is required'            
        ];
    }
}
