<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class RoleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules=  [
            'title' => 'bail|required|string|unique:roles,name,'.$this->id,
            'description' => 'bail',
            'permissions' => 'bail|required|array'            
        ];
        return $rules;
    }

    public function attributes(){
        return[
            'title' => 'Title'
        ];
    }

    public function messages(){
        return [
            // 'title.unique' => 'Role :Attribute already exists',            
            'title.unique' => 'Role  already exists',            
        ];
    }
}
