<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StudentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'number' => 'bail|required',
            'cnic' => 'bail|nullable|regex:/^[0-9]{5}-[0-9]{7}-[0-9]$/',
            'gender' => 'bail|required|string',
            'first_name' => 'bail|required|string',
            'address' => 'bail|required|string',
            'last_name' => 'bail|required|string',
            'guardian_name' => 'bail|required|string',
            'campus_id' => 'bail|required|numeric',
            'grade_id' => 'bail|required|numeric',
            'section_id' => 'bail|required|numeric',
            'admission_date' => 'bail|required',
            'dob' => 'bail|required',
            'email' => 'bail',                        
            'phone' => 'bail|required',            
            // 'fees.*.type'   => 'bail|required',
            // 'fees.*.amount'   => 'bail|required',
            'secondary_phone' => 'bail',            
            'avatar' => 'bail'       
        ];
    }

    public function messages(){
        return [            
            'grade_id.required' => 'Class is required',            
            'section_id.required' => 'Section is required',            
            'campus_id.required' => 'Campus is required',            
            'dob.required' => 'Date of Birth is required',
            // 'fees.*.type.required' => 'Fee type is required',            
            // 'fees.*.amount.required' => 'Fee amount is required',            
        ];
    }
}
