<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Log;
class UserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        Log::debug("User ID", [$this->user_id]);
        $rules=  [
            'code' => 'bail|required|unique:staff,code,'.$this->id,
            'cnic' => 'bail|required|regex:/^[0-9]{5}-[0-9]{7}-[0-9]$/|unique:staff,cnic,'.$this->id,
            'title' => 'bail|required|string',
            'first_name' => 'bail|required|string',
            'last_name' => 'bail|required|string',
            'address' => 'bail|required|string',
            'department' => 'bail',
            'campus_id' => 'bail',
            'phone' => 'bail|required',
            'secondary_phone' => 'bail',
            'avatar' => 'bail',
            'email' => 'bail|required_if:has_account,true|email|unique:users,email,'.$this->user_id,
            'roles' => 'bail|required_if:has_account,true',
            'joined_at' => 'bail|required_if:has_payroll,true',
            'basic_salary' => 'bail|required_if:has_payroll,true',
            'allowances.*.type'   => 'bail|required_if:has_payroll,true',
            'allowances.*.amount'   => 'bail|required_if:has_payroll,true',
            'password' => 'bail|required_if:has_account,true|same:confirm_password|min:8',
            
        ];
        if($this->id){            
            if($this->change_password == "true"){            
                $rules['password'] = 'bail|required_if:change_password,true|min:8|max:20|same:confirm_password';
            }else{
                $rules['password'] = 'bail';
            }
        }
        

        return $rules;
    }

    /**
     * messages
     *
     * @return void
     */
    public function messages(){
        return [                        
            'allowances.*.type.required_if' => 'Allowance type is required',            
            'allowances.*.amount.required_if' => 'Allowance amount is required',            
        ];
    }
}
