<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class GradeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id'            => $this->id,
            'title'         => $this->title, 
            'label'         => $this->label,
            'description'   => $this->description,
            'sections'      => SectionResource::collection($this->sections),
            'updated_at'    => $this->updated_at            
        ];
    }
}
