<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PayrollResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id'            => $this->id,
            'user'          => new StaffResource($this->staff),
            'joined_at'     => $this->joined_at,
            'basic_salary'  => $this->basic_salary,
            'allowances'    => $this->allowances
        ];
    }
}
