<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class StudentInfoResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id'            => $this->id,
            'number'        => $this->number,
            'code'          => $this->code,                    
            'first_name'    => $this->first_name,            
            'last_name'     => $this->last_name,                        
            'campus'        => $this->campus->only(['id', 'title']),
            'class'         => $this->grade->only(['id', 'title']),
            'section'       => $this->section->only(['id', 'title']),
            'avatar'        => new MediaResource($this->avatar),            
        ];
    }
}
