<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class StudentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id'            => $this->id,
            'code'          => $this->code,
            'number'        => $this->number,
            'address'       => $this->address,
            'gender'        => $this->gender,
            'first_name'    => $this->first_name,            
            'last_name'     => $this->last_name,
            'admission_date'=> $this->admission_date, 
            'guardian_name' => $this->guardian_name,           
            'dob'           => $this->dob,
            'cnic'          => $this->cnic,
            'email'         => $this->email,
            'contacts'      => $this->contacts,
            'fees'          => $this->fees,
            'campus'        => $this->campus->only(['id', 'title']),
            'class'         => $this->grade->only(['id', 'title']),
            'section'       => $this->section->only(['id', 'title']),
            'avatar'        => new MediaResource($this->avatar),
            'documents'     => MediaResource::collection($this->documents),                       
            'updated_at'    => $this->updated_at,                        
            'status'        => $this->status            
        ];
    }
}
