<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Attendance extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'attendance';

    protected $fillable = [
        'attendable_id',
        'attendable_type',
        'checkin',
        'checkout',
        'status',
        'comments'
    ];

    protected $casts = [
        'id'            => 'integer',
        'attendable_id' => 'integer'        
    ];

    public function attendable(){        
        return $this->morphTo();
    }
}
