<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Student extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'first_name',
        'last_name',
        'number',
        'code',
        'email',
        'guardian_name',
        'contacts',
        'address',
        'bio',
        'fees',
        'admission_date',
        'dob',
        'campus_id',
        'grade_id',
        'section_id',
        'status',
        'gender',
        'cnic'
    ];

    protected $casts = [
        'id'            => 'integer',
        'contacts'      => 'array',
        'bio'           => 'array',
        'fees'          => 'array',
        'campus_id'     => 'integer',
        'grade_id'      => 'integer',
        'section_id'    => 'integer',
    ];

    public function campus(){
        return $this->belongsTo(Campus::class);
    }

    public function grade(){
        return $this->belongsTo(Grade::class);
    }

    public function section(){
        return $this->belongsTo(Section::class);
    }

    public function avatar(){
        return $this->morphOne(Media::class, 'mediable')->where('type', MediaType::AVATAR);        
    }

    public function documents(){
        return $this->morphMany(Media::class, 'mediable')->where('type', MediaType::DOC);
    }

    public function attendance(){
        return $this->morphMany(Attendance::class, 'attendable');
    }

}
