<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Transaction extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'transactable_id',
        'transactable_type',
        'ref',
        'type',
        'user_id',
        'amount',
        'status',
        'comments'
    ];

    protected $casts = [
        'id'            => 'integer',
        'attendable_id' => 'integer'        
    ];

    public function transactable(){        
        return $this->morphTo();
    }
}
